﻿//////////////////////////////////////////////
// ProjectLoadQuery.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkAstraeus
{
	class ResourceDeclAugmentCallback ;
}

/// Includes ---------------------------------

// nkAstraeus
#include "../../Dll/DllDefines.h"

// nkGraphics
#include <NilkinsGraphics/Resources/ResourceSetLoadQuery.h>

// nkMemory
#include <NilkinsMemory/Containers/String.h>

// nkScripts
#include <NilkinsScripts/Exporter/Project/ProjectLoadQuery.h>

/// Internals --------------------------------

namespace nkAstraeus
{
	struct ProjectLoadQueryInformation final
	{
		ResourceDeclAugmentCallback* _augmentCallback = nullptr ;

		bool _materials = true ;
	} ;
}

/// Class ------------------------------------

namespace nkAstraeus
{
	struct DLL_ASTRAEUS_EXPORT ProjectLoadQuery final
	{
		// Path, overriding an other in sub queries
		nkMemory::String _path ;

		// Sub queries
		ProjectLoadQueryInformation _astraeusQuery ;
		nkGraphics::ResourceSetLoadQuery _graphicsQuery ;
		nkScripts::ProjectLoadQuery _scriptsQuery ;
	} ;
}